IF IndexProperty(Object_Id('Clientes_Links'), 'IX_Clil_PorCli_url', 'IndexID') IS NOT NULL
	DROP INDEX IX_Clil_PorCli_url ON Clientes_Links
GO 
CREATE INDEX IX_Clil_PorCli_url ON  Clientes_Links (Id_Cliente, Fecha_Gen DESC)
INCLUDE (Url)
GO


IF IndexProperty(Object_Id('Cbtes_Items'), 'IX_CBTI_Cli_Prod_Venc', 'IndexID') IS NOT NULL
	DROP INDEX IX_CBTI_Cli_Prod_Venc ON Cbtes_Items
GO 
CREATE INDEX IX_CBTI_Cli_Prod_Venc ON Cbtes_Items (Id_Cliente, Id_Producto, Fecha_Venc);



IF IndexProperty(Object_Id('Contratos'), 'IX_Cont_PorCli_Tip_Act_Des_Has', 'IndexID') IS NOT NULL
	DROP INDEX IX_Cont_PorCli_Tip_Act_Des_Has ON Contratos
GO 
CREATE INDEX IX_Cont_PorCli_Tip_Act_Des_Has ON Contratos(Id_Cliente, Id_Tipo_Con, Activo, Fecha_Desde, Fecha_Hasta);


IF IndexProperty(Object_Id('Cbtes'), 'IX_CBT_TransOrig_Tipo', 'IndexID') IS NOT NULL
	DROP INDEX IX_CBT_TransOrig_Tipo ON Cbtes
GO 
CREATE NONCLUSTERED INDEX IX_CBT_TransOrig_Tipo
	ON Cbtes (Id_Trans_Origen,Id_Estado_Cbte)
	INCLUDE (Id_Tipo_Cbte)


IF IndexProperty(Object_Id('Clientes_Links'), 'IX_Clil_PorCli_FD', 'IndexID') IS NOT NULL
	DROP INDEX IX_Clil_PorCli_FD ON Clientes_Links
GO 
CREATE NONCLUSTERED INDEX [IX_Clil_PorCli_FD] ON Clientes_Links(Id_Cliente, Fecha_Desde) INCLUDE (Url);


IF IndexProperty(Object_Id('Contratos'), 'IX_Cont_PorCli_Tip_Act_FH', 'IndexID') IS NOT NULL
	DROP INDEX IX_Cont_PorCli_Tip_Act_FH ON Contratos
GO 
CREATE NONCLUSTERED INDEX [IX_Cont_PorCli_Tip_Act_FH] ON Contratos(Id_Cliente, Id_Tipo_Con, Activo, Fecha_Hasta);

IF IndexProperty(Object_Id('Cbtes_Items'), 'IX_CBTI_Cli_Pro_Ser_FV', 'IndexID') IS NOT NULL
	DROP INDEX IX_CBTI_Cli_Pro_Ser_FV ON Cbtes_Items
GO
CREATE NONCLUSTERED INDEX [IX_CBTI_Cli_Pro_Ser_FV] ON Cbtes_Items(Id_Cliente, Id_Producto, Serie, Fecha_Venc);

IF IndexProperty(Object_Id('Tab_Ent_Protocolares'), 'IX_EntP_PorCli_Act', 'IndexID') IS NOT NULL
	DROP INDEX IX_EntP_PorCli_Act ON Tab_Ent_Protocolares
GO
CREATE NONCLUSTERED INDEX [IX_EntP_PorCli_Act] ON Tab_Ent_Protocolares (Id_Cliente, Activo) INCLUDE (Id_Ent_Protocolo);

IF IndexProperty(Object_Id('Clientes'), 'IX_CLI_PorCliRef_Doc_Pas_Cred_Ras', 'IndexID') IS NOT NULL
	DROP INDEX IX_CLI_PorCliRef_Doc_Pas_Cred_Ras ON Clientes 
GO
CREATE NONCLUSTERED INDEX [IX_CLI_PorCliRef_Doc_Pas_Cred_Ras] ON Clientes (Id_Cliente, Doc_Nro, Pasap_Nro, Credencial_Nro, Razon_Social);


IF IndexProperty(Object_Id('Cbtes'), 'IX_CBT_PorTran_Est_Lis_Fec', 'IndexID') IS NOT NULL
	DROP INDEX IX_CBT_PorTran_Est_Lis_Fec ON Cbtes
GO
CREATE NONCLUSTERED INDEX [IX_CBT_PorTran_Est_Lis_Fec] ON Cbtes (Id_Trans, Id_Estado_Cbte, Id_Lista, Fecha);

IF IndexProperty(Object_Id('Cbtes_Items'), 'IX_CBTI_PorTran_Cli_Prod_Ven_Ser', 'IndexID') IS NOT NULL
	DROP INDEX IX_CBTI_PorTran_Cli_Prod_Ven_Ser ON Cbtes_Items
GO
CREATE NONCLUSTERED INDEX [IX_CBTI_PorTran_Cli_Prod_Ven_Ser] ON Cbtes_Items (Id_Trans, Id_Cliente, Id_Producto, Fecha_Venc, Serie);

IF IndexProperty(Object_Id('Productos'), 'IX_PRO_PorPro_Tip_Act_Sec', 'IndexID') IS NOT NULL
	DROP INDEX IX_PRO_PorPro_Tip_Act_Sec ON Productos
GO
CREATE NONCLUSTERED INDEX [IX_PRO_PorPro_Tip_Act_Sec] ON Productos (Id_Producto, Tipo, Activo, Id_Sector);

IF IndexProperty(Object_Id('Prod_Listas_Precios'), 'IX_PROLP_PorGru_Lis', 'IndexID') IS NOT NULL
	DROP INDEX IX_PROLP_PorGru_Lis ON Prod_Listas_Precios
GO
CREATE NONCLUSTERED INDEX [IX_PROLP_PorGru_Lis] ON Prod_Listas_Precios (Id_Evento_Grupo, Id_Lista_Precio);

IF IndexProperty(Object_Id('Cbtes_Tipos'), 'IX_CBTT_PorTip_Ped_Fac', 'IndexID') IS NOT NULL
	DROP INDEX IX_CBTT_PorTip_Ped_Fac ON Cbtes_Tipos
GO
CREATE NONCLUSTERED INDEX [IX_CBTT_PorTip_Ped_Fac] ON Cbtes_Tipos (Id_Tipo_Cbte, Compromete_Pedido, Compromete_Factura);

IF IndexProperty(Object_Id('Clientes'), 'IX_Cli_PorAct_Cli_Tip', 'IndexID') IS NOT NULL
	DROP INDEX IX_Cli_PorAct_Cli_Tip ON Clientes
GO
CREATE NONCLUSTERED INDEX [IX_Cli_PorAct_Cli_Tip]
	ON [Clientes] ([Activo], [Id_Cliente], [Id_Tipo_Cli])
	INCLUDE ([Razon_Social], [Id_Tipo_Doc], [Doc_Nro], [Id_Cliente_Externo], [Credencial_Nro], [Ult_Cuota_Paga], [Pasap_Nro]);


IF IndexProperty(Object_Id('Clientes'), 'IX_Cli_PorActivo', 'IndexID') IS NOT NULL
	DROP INDEX IX_Cli_PorActivo ON Clientes
GO

IF IndexProperty(Object_Id('Clientes'), 'IX_CLI_PorActivo_Id', 'IndexID') IS NOT NULL
	DROP INDEX IX_CLI_PorActivo_Id ON Clientes
GO

IF IndexProperty(Object_Id('clientes_xcampos'), 'IX_CliXC_PorId_Cam_Int', 'IndexID') IS NOT NULL
	DROP INDEX IX_CliXC_PorId_Cam_Int ON clientes_xcampos
GO
CREATE NONCLUSTERED INDEX [IX_CliXC_PorId_Cam_Int]
	ON clientes_xcampos (Id_Cliente, id_campo, valor_integer);

IF IndexProperty(Object_ID('dbo.Productos'), 'IX_Pro_ActVend', 'IndexID') IS NOT NULL
    DROP INDEX [IX_Pro_ActVend] ON [dbo].[Productos];
GO
CREATE NONCLUSTERED INDEX IX_Pro_ActVend
	ON [dbo].[Productos] ([Activo],[Vendible])
	INCLUDE ([Descripcion_Detallada],[Descripcion_Resumida],[Id_Familia],[Foto_Chica],[Foto_Grande],[Tipo],[Flag_Mes],[Flag_Periodo],[Flag_Periodo_Tipo],[Flag_Periodo_Desde],[Flag_Periodo_Hasta],[Flag_Periodo_Cant],[Id_Tipo_Con_Web_Auto])
	GO

IF IndexProperty(Object_Id('Clientes_Temp'), 'IX_Clit_Busquedas', 'IndexID') IS NOT NULL
	DROP INDEX IX_Clit_Busquedas ON Clientes_Temp
GO
CREATE NONCLUSTERED INDEX IX_Clit_Busquedas 
	ON Clientes_Temp (
		Id_Cliente_Temp DESC,
		Fecha,
		Id_Estado_Solicitud,
		Id_Pais,
		Flag_Pago
	)
	INCLUDE (
		Flag_Modificacion,
		legajo,
		Id_Tipo_Cli,
		Id_Cliente,
		Razon_Social,
		Sexo,
		Email,
		Telefono,
		Doc_Nro,
		Provincia_Descrip,
		Localidad_Descrip,
		Direccion,
		Tel_Movil,
		Fecha_Nac
	)

IF IndexProperty(Object_Id('Cbtes_Items'), 'IX_CBTI_PorProdTransQA', 'IndexID') IS NOT NULL
	DROP INDEX IX_CBTI_PorProdTransQA ON Cbtes_Items
GO
CREATE INDEX IX_CBTI_PorProdTransQA on Cbtes_Items (Id_Producto, Id_Trans, Flag_QA)

IF IndexProperty(Object_Id('Cbtes_Tipos'), 'IX_CBTT_PorTipoStkVtas', 'IndexID') IS NOT NULL
	DROP INDEX IX_CBTT_PorTipoStkVtas ON Cbtes_Tipos
GO 
CREATE INDEX IX_CBTT_PorTipoStkVtas on Cbtes_Tipos (Id_Tipo_Cbte, Compromete_Stock, Compromete_Stock_Res, Compromete_Factura)

IF IndexProperty(Object_Id('CRM_Contactos'), 'IX_CRCT_PorCli_FR_Est_Padre', 'IndexID') IS NOT NULL
	DROP INDEX IX_CRCT_PorCli_FR_Est_Padre ON CRM_Contactos
GO
CREATE NONCLUSTERED INDEX IX_CRCT_PorCli_FR_Est_Padre
	ON CRM_Contactos (
		Id_Cliente,
		Fecha_Reso,
		Id_Estado,
		Id_Contacto_Padre
	)
	INCLUDE (Id_Contacto);


IF IndexProperty(Object_Id('Contratos'), 'IX_Cont_PorAct_FD_FH_Cont', 'IndexID') IS NOT NULL
	DROP INDEX IX_Cont_PorAct_FD_FH_Cont ON Contratos
GO
CREATE NONCLUSTERED INDEX IX_Cont_PorAct_FD_FH_Cont
	ON Contratos (Activo, Fecha_Desde, Fecha_Hasta, Id_Contrato)

IF IndexProperty(Object_Id('Contratos_Prod'), 'IX_ContP_PorPro_Cont_FamS', 'IndexID') IS NOT NULL
	DROP INDEX IX_ContP_PorPro_Cont_FamS ON Contratos_Prod
GO
CREATE NONCLUSTERED INDEX IX_ContP_PorPro_Cont_FamS
	ON Contratos_Prod (Id_Producto, Id_Contrato, Id_Prod_Familia_Sala)

IF IndexProperty(Object_Id('Contratos_Prod_Horarios'), 'IX_CONPROHOR_PorCont_FamH', 'IndexID') IS NOT NULL
	DROP INDEX IX_CONPROHOR_PorCont_FamH ON Contratos_Prod_Horarios
GO
CREATE NONCLUSTERED INDEX IX_CONPROHOR_PorCont_FamH
	ON Contratos_Prod_Horarios (Id_Contrato, Id_Prod_Familia_Horario)

IF IndexProperty(Object_Id('CD_Clientes_Novedades'), 'IX_CDCLNV_PorCliEstFecha', 'IndexID') IS NOT NULL
	DROP INDEX IX_CDCLNV_PorCliEstFecha ON CD_Clientes_Novedades
GO
CREATE INDEX IX_CDCLNV_PorCliEstFecha ON CD_Clientes_Novedades (Id_Cliente,Estado,Fecha)